#!/bin/sh
# inherits LOG_FILE PROGRESS_FILE END_FILE ERR_FILE

local ERR="1"
local TMP="/tmp/upload_fw"
local MOUNTED_RW="0"

do_upgrade() {

cd $TMP || return 1

echo "Mount read-write..."
MOUNTED_RW="1"
mount -oremount -w / || return 1

if [ -f "style.html" ]; then
    echo "Installing style..."
    cp -f style.html /var/boa/gsmbr
    cp -f style.html /var/boa/guard
fi

if [ -f "logo.img" ]; then
    echo "Installing logo..."
    cp -f logo.img /var/boa/gsmbr
    cd /var/boa/guard && ln -sf ../gsmbr/logo.img
fi

sync || return 1

echo "Mount readonly..."
mount -oremount -r / || return 1
MOUNTED_RW="0"

echo "Installation finished successfully."
ERR=0
}

if [ -z "$LOG_FILE" ]; then
    LOG_FILE=/tmp/log
fi

do_upgrade >> $LOG_FILE 2>&1
if [ "$ERR" != "0" ]; then
    if [ "$MOUNTED_RW" = "1" ]; then
        echo "Mount readonly..."
        mount -oremount -r /
    fi
    echo "Installation failed!" >> $LOG_FILE
fi

if [ -n "$END_FILE" ]; then
    echo -n > $END_FILE
fi
